


%% Plot parameter
%Getting the data of the sideview to norm all values
[filepath,name,ext]=fileparts(pwd)
name=replace(name, 'top' ,'side')
fullfile(filepath,name,'norm_x.txt')
fileID_1 = fopen(fullfile(filepath,name,'\norm_x.txt'));
norm = textscan(fileID_1, '%n')
fclose(fileID_1)
stimulation_frequency=strsplit(name,'_')
%stimulation_frequency=strsplit(name,',')
if (length(strfind(name,','))~=0)
    replace(stimulation_frequency,',','.')
end

stimulation_frequency=stimulation_frequency{1}

%stimulation_frequency=join(stimulation_frequency{1},".",stimulation_frequency{2})
stimulation_frequency=str2double(stimulation_frequency)

  
norm=cell2mat(norm)
%display(data(1,:,1))
%display(data(1,:,2))
% colour
blue = [31 119 180]/256;
red = [214 39 40 ]/256;




%define layout parameters
fontsize = 12;
linewidthax =1;
linewidthplot= 2;
figureheight = 7; %in cm
figurewidth = 12;  %in cm
figureposx = 15;
figureposy = 15;
color1 = 'r';
color2 = 'b';
color3 = [0.1 0.1 0.1];

ax_range =[0.8 5.2 -0.1 2];
blue = [31 119 180]/256;
red = [214 39 40 ]/256;






%---------------------------------------
% measurement parameters

burst_time = 750*10^-6;
puls_time = [750.001*10^-6 750.00067*10^-6 750.0005*10^-6 750.0004*10^-6 ...
    750.00033*10^-6 750.000286*10^-6];

frame_time = 1/15;  %in s




number_of_pics = [200 200 200 200 200 200 200 200 200 200 200]-1;
number_of_markes =1;



%---------------------------------------
currentFolder = pwd;

frequencies = 120; %[20 40 60 80 100 120 140 160 180 200];
%frequencies = [ 80 80 80  ]
number_of_mes_positions =1;

mesdatax= zeros(number_of_mes_positions,length(frequencies),max(number_of_pics));
mesdatay= zeros(number_of_mes_positions,length(frequencies),max(number_of_pics));


number_of_freq = 10000;

fouriertransx = zeros(number_of_mes_positions, length(frequencies), number_of_freq);
fouriertransy = zeros(number_of_mes_positions, length(frequencies), number_of_freq);


phi_angles = zeros(number_of_mes_positions, length(frequencies));

for i = 1:number_of_mes_positions
    if i == 1
        folder = '';
    elseif i == 2
        folder = '_oben';
%     elseif i ==4
%         folder = '_oben_3';
%     elseif i == 2
%         folder = '_3';
    end
    
    
    for freq_count = 1:length(frequencies)
        
        
        %repetitions = frame_time/puls_time(freq_count);
        %time_increment_pics = repetitions*(puls_time(freq_count)-burst_time);
        delta_f = 0.75; % in hz
        time_increment_pics= 1/frequencies(freq_count)/1000*frame_time*delta_f;
        time = 0:time_increment_pics:(number_of_pics(freq_count)-1)*time_increment_pics;
        
        frequency = [num2str(frequencies(freq_count)) 'khz_8Vpp'];
        
        mesx = zeros(1,number_of_pics(freq_count));
        mesy = zeros(1,number_of_pics(freq_count));
        filteredmesx = zeros(1,number_of_pics(freq_count));
        filteredmesy = zeros(1,number_of_pics(freq_count));
        highpassmesx = zeros(1,number_of_pics(freq_count));
        highpassmesy = zeros(1,number_of_pics(freq_count));
        
        for l = 1:1
            
            
            measurementx = [adress_top1];
            measurementy = [adress_top2];
            
            filename1 = [ measurementx ];
            filename2 = [ measurementy ];
            
            
            mesx = mean(importdata(filename1))/1;
            mesy = mean(importdata(filename2))/1;
            
            
        end
        mesx1 = zeros(1,number_of_pics(freq_count));
        mesy1 = zeros(1,number_of_pics(freq_count));
        for l = 1:1 %for getting data of the second cylinder of the fork
            
            
            measurementx1 = [];
            measurementy1 = ['validy1.dat'];
            
            filename1 = [ measurementx1 ];
            filename2 = [ measurementy1 ];
            
            
            mesx1 = mean(importdata(filename1))/1;
            mesy1 = mean(importdata(filename2))/1;
            
           
        end
        
        mesx1 = mesx1-mesx1(1);
        mesy1 = -mesy1+mesy1(1);
        
        mesx = mesx-mesx(1);
        mesy = -mesy+mesy(1);
        
        %Comparison of the two cylinders
        part_antisym=(mesy-mesy1)/(2*norm(1,1))
        part_sym=(mesy+mesy1)/(2*norm(1,1))
        
       
        mesdatax(i,freq_count,1:length(mesx)) = mesx;
        mesdatay(i,freq_count,1:length(mesy)) = mesy;
        
        
        
        % parameter for fourier transform
        freq_start = 0;
        freq_end = 1/(time_increment_pics);
        
        
        freq_fourier = linspace(freq_start,freq_end,number_of_freq);
        
        normalisation1 = -(freq_start-freq_end)/number_of_freq;
        
        fourierx = zeros(1,length(freq_fourier));
        fouriery = zeros(1,length(freq_fourier));
        fourierfilteredx = zeros(1,length(freq_fourier));
        fourierfilteredy = zeros(1,length(freq_fourier));
        highpassx = zeros(1,length(freq_fourier));
        highpassy = zeros(1,length(freq_fourier));
        
        
        for f = 1:length(freq_fourier)
            
            fourierx(1,f) = sum(mesx...
                .*exp(1i*time*freq_fourier(f)*2*pi))*normalisation1;
            
            fouriery(1,f) = sum(mesy...
                .*exp(1i*time*freq_fourier(f)*2*pi))*normalisation1;
        end
        
        fouriertransx(i,freq_count,:) = fourierx;
        fouriertransy(i,freq_count,:) = fouriery;
        
        
        
        
        
        %filtering
        
        highpass_cutoff = (frequencies(freq_count)-50)*1000;
        if highpass_cutoff <0
            highpass_cutoff = 10000;
        end
        %if highpass_cutoff < 50000
        %    highpass_cutoff = 50000;
        %end
        
        index_high_cutoff = find(freq_fourier > highpass_cutoff);
        
        lowpass_cutoff = 200000;%(frequencies(freq_count)+20)*1000;
        
        index_low_cutoff = find(freq_fourier < lowpass_cutoff);
        
        
        temperature = 10;
        fourierfilteredx =  fourierx...
            ./(exp(((1:length(freq_fourier))-index_low_cutoff(end))/temperature)+1)...
            ./(exp(-((1:length(freq_fourier))-index_high_cutoff(1))/temperature)+1);
        
        fourierfilteredy =  fouriery...
            ./(exp(((1:length(freq_fourier))-index_low_cutoff(end))/temperature)+1)...
            ./(exp(-((1:length(freq_fourier))-index_high_cutoff(1))/temperature)+1);
        
        highpassx =  fourierx...
            ./(exp(-((1:length(freq_fourier))-index_high_cutoff(1))/temperature)+1);
        
        highpassy =  fouriery...
            ./(exp(-((1:length(freq_fourier))-index_high_cutoff(1))/temperature)+1);
        
        filterfunktion_highpass = 1./(exp(-((1:length(freq_fourier))-index_high_cutoff(1))/temperature)+1);
        
        filterfunktion = 1./(exp(((1:length(freq_fourier))-index_low_cutoff(end))/temperature)+1)...
            ./(exp(-((1:length(freq_fourier))-index_high_cutoff(1))/temperature)+1);
        
        %fourierfiltereddatax(i,freq_count,:)
        
        % back transformation
        
        normalisation2 = time_increment_pics*2; %factor two because one drops half of the spectra
        
        for t = 1:length(time)
            
            filteredmesx(t) = real(sum(fourierfilteredx...
                .*exp(-1i*time(t)*freq_fourier*2*pi)))*normalisation2;
            filteredmesy(t) = real(sum(fourierfilteredy...
                .*exp(-1i*time(t)*freq_fourier*2*pi)))*normalisation2;
            
            highpassmesx(t) = real(sum(highpassx...
                .*exp(-1i*time(t)*freq_fourier*2*pi)))*normalisation2;
            highpassmesy(t) = real(sum( highpassy...
                .*exp(-1i*time(t)*freq_fourier*2*pi)))*normalisation2;
        end
        
        %filteredmesx(i,freq_count,t)
        
        figure;
        %______________________________________________
        %plot parameters and reflection cutoff
        
        pic_number_start = [60 60 60 60 ];%round([100 180 180]*frequencies(freq_count)/200);
        pic_number_refl = [ 140 140 140 140];%round(([100 180 180]*1.5+150)*frequencies(freq_count)/200);
        
        %pic_number_start = [1 1 1];
        %pic_number_refl = [249 249 249];
        f =figure(freq_number);
        
        set(f, 'Position', [50, 50, 900, 1000]);
        
        subplot_rows = 7;
        subplot_collums = number_of_mes_positions;
        
        %______________________________________________
        
        
        subplot(subplot_rows,subplot_collums,i)
        r1 = rectangle('Position',[time(pic_number_refl(i))*10^6 ...
            min(min([mesx, mesy]))...
            time(end)*10^6-time(pic_number_refl(i))*10^6 ...
            max(max([mesx, mesy]))-...
            min(min([mesx, mesy]))]);
        r = rectangle('Position',[0 ...
            min(min([mesx, mesy]))...
            time(pic_number_start(i))*10^6 ...
            max(max([mesx, mesy]))-...
            min(min([mesx, mesy]))]);
        
        hold on
        plot(time*10^6,mesx)
        plot(time*10^6,mesy)
        
        r1.FaceColor = [.8 .8 .8];
        r1.EdgeColor = [.8 .8 .8];
        r.FaceColor = [.8 .8 .8];
        r.EdgeColor = [.8 .8 .8];
        title(['frequency ' num2str(frequencies(freq_count)) 'khz ' folder])
        xlabel('time in \mus')
        ylabel('Disp in pixel')
        scale =1;
%               Fig = figure(10+i)
%         r1 = rectangle('Position',[time(pic_number_refl(i))*10^6 ...
%             min(min([mesx*scale, mesy*scale]))...
%             time(end)*10^6-time(pic_number_refl(i))*10^6 ...
%             max(max([mesx*scale, mesy*scale]))-...
%             min(min([mesx*scale, mesy*scale]))]);
%         r = rectangle('Position',[0 ...
%             min(min([mesx*scale, mesy*scale]))...
%             time(pic_number_start(i))*10^6 ...
%             max(max([mesx*scale, mesy*scale]))-...
%             min(min([mesx*scale, mesy*scale]))]);
% 
%         hold on
%         h = plot(time*10^6,mesx*scale,'Color', red)
%         set(h, 'LineWidth',linewidthplot);
%         h = plot(time*10^6,mesy*scale,'Color',blue)
%         set(h, 'LineWidth',linewidthplot);
% 
%         r1.FaceColor = [.8 .8 .8];
%         r1.EdgeColor = [.8 .8 .8];
%         r.FaceColor = [.8 .8 .8];
%         r.EdgeColor = [.8 .8 .8];
%         
%         %xlabel('time in \mus')
%         %ylabel('Disp in pixel')
%         
%         
%         %axis([-5.4414 5.4414 0 0.045*change])
% ax = gca;
% %ax.XTick= [-5.4414 0 3.1416 sqrt(2*3.1416^2) 5.4414]
% %ax.XTickLabel={'H','\rm{\Gamma}','X','M','H'};
% %ylabel('normalized frequency \it{a}/\lambda','FontSize', fontsize)
% ylabel('Displacement in nm','FontSize', fontsize)
% 
% xlabel('Time in \mus','FontSize', fontsize)
% %legend('FE sim Chiral','FE sim CS','exp Chiral Strain: 0.5%','exp Chiral Strain: 1%','exp Chiral Strain: 1.5%',...
% %    'exp CS Strain: 0.5%','exp CS Strain: 1%','exp CS Strain: 2%')
% %legend('Location','southeast')
% %legend('boxoff')
% set(Fig,'units', 'centimeters','Position', [figureposx, figureposy, figurewidth, figureheight])
% box on
% grid on
% 
% set(Fig, 'Color', 'w');
% 
% set(ax,'linewidth',linewidthax) 
% set(ax, 'GridLineStyle', '-')
% set(ax, 'GridColorMode', 'manual')
% set(ax, 'GridColor' ,color3)
% set(ax, 'TickLength',[0.02 0.02]);
% ax.XColor = 'k';
% ax.YColor = 'k';
        %______________________________________________
        
        
        
        subplot(subplot_rows,subplot_collums,i+subplot_collums)
        plot(freq_fourier/1000,abs(fourierx))
        hold on
        plot(freq_fourier/1000,abs(fouriery))
        plot(freq_fourier/1000,filterfunktion*0.5*max(max([abs(fourierx),...
            abs(fouriery)])),'k--')
        
        xlabel('frequency in kHz')
        ylabel('abs(FT(displ(t))')
        axis([0 600 0 abs(max(max([fouriery,fouriery])))])
        
        
        
        %______________________________________________
        
        
        
        
        subplot(subplot_rows,subplot_collums,i+subplot_collums*2)
        plot(freq_fourier/1000,abs(fourierfilteredx))
        hold on
        plot(freq_fourier/1000,abs(fourierfilteredy))
        %plot(freq/1000,abs(highpassx))
        %plot(freq/1000,abs(highpassy))
        xlabel('frequency in kHz')
        ylabel('abs(FT(displ(t))')
        axis([0 600 0 abs(max(max([abs(fourierfilteredy),...
            abs(fourierfilteredx)])))])
        
        
        
        %______________________________________________
        
        
        %
        %         subplot(subplot_rows,subplot_collums,i+12)
        %         plot(time*10^6,squeeze(highpassmesx(i,freq_count,:)))
        %         hold on
        %         plot(time*10^6,squeeze(highpassmesy(i,freq_count,:)))
        %         xlabel('time in \mus')
        %         ylabel('Disp in pixel')
        %
        
        %______________________________________________
        
        
        
        
        subplot(subplot_rows,subplot_collums,i+subplot_collums*3)
        hold on
        r1 = rectangle('Position',[time(pic_number_refl(i))*10^6 ...
            min(min([filteredmesx, filteredmesy]))...
            time(end)*10^6-time(pic_number_refl(i))*10^6 ...
            max(max([filteredmesx, filteredmesy]))-...
            min(min([filteredmesx, filteredmesy]))]);
        r = rectangle('Position',[0 ...
            min(min([filteredmesx, filteredmesy]))...
            time(pic_number_start(i))*10^6 ...
            max(max([filteredmesx, filteredmesy]))-...
            min(min([filteredmesx, filteredmesy]))]);
        r1.FaceColor = [.8 .8 .8];
        r1.EdgeColor = [.8 .8 .8];
        r.FaceColor = [.8 .8 .8];
        r.EdgeColor = [.8 .8 .8];
        
        plot(time*10^6,filteredmesx)
        plot(time*10^6,filteredmesy)
        xlabel('time in \mus')
        ylabel('Disp in pixel')
        amplx(i, freq_count) = mean(abs(filteredmesx(pic_number_start:pic_number_refl)))*sqrt(2);
        amply(i, freq_count) = mean(abs(filteredmesy(pic_number_start:pic_number_refl)))*sqrt(2);
        
        %Eqn2 = 'a*cos(2*pi*c*x+b)';
        
        %fitdatax=fit(time(pic_number_start(i):pic_number_refl(i))'*10^6, ...
        %    filteredmesx(pic_number_start(i):pic_number_refl(i))',Eqn2);
        % fitdatay=fit(time(pic_number_start(i):pic_number_refl(i))'*10^6,...
        %     filteredmesy(pic_number_start(i):pic_number_refl(i))',Eqn2);
        %plot(fitdatax)
        %plot(fitdatay)
        
        %______________________________________________
        
        %fitdatahigh=fit(squeeze(highpassmesx(i,freq_count,pic_number_start(i):pic_number_refl(i))),...
        %    squeeze(highpassmesy(i,freq_count,pic_number_start(i):pic_number_refl(i))),'poly1');
        filteredmesx=filteredmesx/norm(1,1)
        filteredmesy=filteredmesy/norm(1,1)
        subplot(subplot_rows,subplot_collums,i+subplot_collums*4)
        plot(highpassmesx(pic_number_start(i):pic_number_refl(i)), ...
            highpassmesy(pic_number_start(i):pic_number_refl(i)))
        axis equal
        hold on
        %plot(fitdatahigh)
        xlabel('Disp in units of the stimulation frequency')
        ylabel('Disp in usf')
        
        
        
        %______________________________________________
        
        %Eqn2 = 'a*cos(2*pi*25*x+b)';
        %Eqn = 'p1*x';
        %fitdata=fit(filteredmesx(pic_number_start(i):pic_number_refl(i))',...
        %filteredmesy(pic_number_start(i):pic_number_refl(i))',Eqn2);
        
        
        
        sub = subplot(subplot_rows,subplot_collums,i+subplot_collums*5);
        plot(filteredmesx(pic_number_start(i):pic_number_refl(i)), ...
            filteredmesy(pic_number_start(i):pic_number_refl(i)))
        axis equal
        hold on
        ellipse_fit_data = fit_ellipse(filteredmesx(pic_number_start(i):pic_number_refl(i)), ...
            filteredmesy(pic_number_start(i):pic_number_refl(i)),sub);
        phi(i,freq_count)= ellipse_fit_data.phi;
        
        xlabel('Disp in units of the stimulation frequency')
        ylabel('Disp in usf')
        
        
        
        %
        %-------------------------------------------
        
        
        if freq_count ==2
            phi(i,freq_count) = phi(i,freq_count) -pi/2;
        end
        rot_angle = phi(1,freq_count);
        rotdatamesx = cos(rot_angle)*filteredmesx-sin(rot_angle)*filteredmesy;
        rotdatamesy = +sin(rot_angle)*filteredmesx+cos(rot_angle)*filteredmesy;
        subplot(subplot_rows,subplot_collums,i+subplot_collums*6)
        
        plot(rotdatamesx(pic_number_start(i):pic_number_refl(i)), ...
            rotdatamesy(pic_number_start(i):pic_number_refl(i)))
        axis equal
        hold on
        
        xlabel('Disp in units of the stimulation frequency')
        ylabel('Disp in usf')
        %
        
        norm = max(rotdatamesx.^2+rotdatamesy.^2);
        if i ==2
            figure(13)
            hold on
            plot(rotdatamesx(pic_number_start(i):pic_number_refl(i))/sqrt(norm), ...
                rotdatamesy(pic_number_start(i):pic_number_refl(i))/sqrt(norm))
            axis equal
            xlabel('Disp in units of the stimulation frequency')
            ylabel('Disp in usf')
        end
    %savefig('try1.fig') %Saving the figure in current folder    
    end
     figure;
        hold on;
            plot(part_sym,'b');
            plot(part_antisym,'r');
        hold off;
        
    %atan(real(fourierfilteredx)/imag(fourierfilteredx))
    %fid = fopen(fullfile(currentfolder,'norm_x.txt'), 'w')
    %fprintf(fid, '%g\t',(abs(max(filteredmesy))+abs(min(filteredmesy)))/2);
    %fclose(fid)
    %for resonance frequency and phase angel plot
    result_frequency={}
    result_frequency=[result_frequency,stimulation_frequency]
    result_frequency=cell2mat(result_frequency)
    result_amplitude={}
    result_amplitude=[result_amplitude,(max(rotdatamesy)+abs(min(rotdatamesy)))/2]
    result_amplitude=cell2mat(result_amplitude)
    
    
    
end


%%
%display(mesx)

%fig = figure;

%plot(frequencies, (phi(2,:)-phi(1,:))/2/pi*360,'x')
%xlabel('frequency in kHZ')
%ylabel('rotation angle in ?')


%fig = figure;
%plot(frequencies, (amplx(2,:)./amplx(1,:)))
%hold on
%plot(frequencies, (amply(2,:)./amply(1,:)))
%ylabel('amplitude ratio');
%xlabel('frequency in kHZ')

%
%
% %%
% xlim_new = zeros(1,2);
% ylim_new = zeros(1,2);
% for j = 1:length(frequencies)
%     f =figure(j);
%     for p = 1:3:16
%         sub_plot_data1 = subplot(subplot_rows,subplot_collums,p);
%         sub_plot_data2 = subplot(subplot_rows,subplot_collums,p+1);
%         sub_plot_data3 = subplot(subplot_rows,subplot_collums,p+2);
%
%         xlim_new(1) = min([sub_plot_data1.XLim(1) sub_plot_data2.XLim(1) sub_plot_data3.XLim(1)]);
%         xlim_new(2) = max([sub_plot_data1.XLim(2) sub_plot_data2.XLim(2) sub_plot_data3.XLim(2)]);
%         ylim_new(1) = min([sub_plot_data1.YLim(1) sub_plot_data2.YLim(1) sub_plot_data3.YLim(1)]);
%         ylim_new(2) = max([sub_plot_data1.YLim(2) sub_plot_data2.YLim(2) sub_plot_data3.YLim(2)]);
%
%
%         sub_plot_data1.XLim = xlim_new;
%         sub_plot_data2.XLim = xlim_new;
%         if p < 8
%             sub_plot_data1.YLim = ylim_new;
%             sub_plot_data2.YLim = ylim_new;
%         end
%
%
%     end
% end